(define-struct rodzic (dzieci imie data oczy))

;; niebieskooki-potomek? : rodzic -> boolean
;; okrela, czy struktura dany-rodzic lub ktrykolwiek potomek (dziecko,
;; wnuk, itd.) ma warto 'niebieskie w polu oczy
(define (niebieskooki-potomek? dany-rodzic)
  (or (symbol=? (rodzic-oczy dany-rodzic) 'niebieskie)
      (niebieskookie-dzieci? (rodzic-dzieci dany-rodzic))))

;; niebieskookie-dzieci? : lista-dzieci -> boolean
;; okrela, czy ktrakolwiek z osb reprezentowanych przez struktury na licie
;; dana-lista-dzieci ma niebieskie oczy lub niebieskookiego potomka
(define (niebieskookie-dzieci? dana-lista-dzieci)
  (cond
    [(empty? dana-lista-dzieci) false]
    [else (or (niebieskooki-potomek? (first dana-lista-dzieci))
              (niebieskookie-dzieci? (rest dana-lista-dzieci)))]))
